
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Jean")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Laura")

    # Define the objective function
    model.setObjective(1*x1**2 + 7*x1*x2 + 1*x2**2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(21*x1 + 24*x2 >= 46, name="paperwork_competence_rating")
    model.addConstr(1*x1 + 16*x2 >= 39, name="dollar_cost_per_hour")
    model.addConstr(21*x1 + 28*x2 >= 22, name="work_quality_rating")
    model.addConstr(8*x1**2 - 9*x2**2 >= 0, name="non_linear_constraint")
    model.addConstr(441*x1**2 + 576*x2**2 <= 90, name="paperwork_competence_rating_squared")
    model.addConstr(1*x1 + 16*x2 <= 80, name="dollar_cost_per_hour_upper_bound")
    model.addConstr(21*x1 + 28*x2 <= 70, name="work_quality_rating_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by Laura: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
