
from gurobipy import Model, GRB

# Create a new model
m = Model("bus_seating")

# Create variables
cushioned_seats = m.addVar(vtype=GRB.INTEGER, name="cushioned_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(30 * cushioned_seats + 10 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(cushioned_seats + regular_seats <= 150, "total_seats")
m.addConstr(cushioned_seats >= 50, "min_cushioned")
m.addConstr(regular_seats >= 2 * cushioned_seats, "regular_preference")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: $', m.objVal)
    print('Cushioned Seats:', cushioned_seats.x)
    print('Regular Seats:', regular_seats.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

