
from gurobipy import *

# Create a new model
m = Model("Bus_Seat_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="cushioned_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set the objective function
m.setObjective(30*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "total_seats")
m.addConstr(x1 >= 50, "min_cushioned_seats")
m.addConstr(x2 >= 2*x1, "regular_vs_cushioned")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cushioned seats: {x1.x}")
    print(f"Regular seats: {x2.x}")
    print(f"Maximum profit: ${30*x1.x + 10*x2.x}")
else:
    print("No optimal solution found")
