
import gurobi

def solve_bus_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cushioned_seats", lb=0, ub=None)
    x2 = model.addVar(name="regular_seats", lb=0, ub=None)

    # Objective function: maximize 30x1 + 10x2
    model.setObjective(30*x1 + 10*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 150, name="total_seats")
    model.addConstr(x1 >= 50, name="min_cushioned_seats")
    model.addConstr(x2 >= 2*x1, name="regular_vs_cushioned")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cushioned Seats: {x1.varValue}")
        print(f"Regular Seats: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bus_seating_problem()
