
import gurobipy as gp

# Create a new model
m = gp.Model("packaging_optimization")

# Create variables
jars = m.addVar(vtype=gp.GRB.CONTINUOUS, name="jars")  # Number of glass jars
plates = m.addVar(vtype=gp.GRB.CONTINUOUS, name="plates")  # Number of plates

# Set objective function
m.setObjective(2 * jars + 2.5 * plates, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * jars + 12 * plates <= 620, "worker_time")  # Worker time constraint
m.addConstr(3 * jars + 4 * plates <= 120, "cardboard")  # Cardboard constraint
m.addConstr(jars >= 0, "jars_nonnegative")  # Non-negativity constraint for jars
m.addConstr(plates >= 0, "plates_nonnegative")  # Non-negativity constraint for plates

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of jars: {jars.x}")
    print(f"Number of plates: {plates.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

