
from gurobipy import *

# Create a new model
m = Model("Packaging_Problem")

# Add variables
x1 = m.addVar(name="glass_jars", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="plates", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2*x1 + 2.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 12*x2 <= 620, name="worker_time")
m.addConstr(3*x1 + 4*x2 <= 120, name="cardboard")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
