
import gurobipy as gp

# Create a new model
model = gp.Model("Factory_Optimization")

# Define variables
x1 = model.addVar(name="glass_jars", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="plates", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 2*x1 + 2.5*x2
model.setObjective(2*x1 + 2.5*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(15*x1 + 12*x2 <= 620, name="worker_time")
model.addConstr(3*x1 + 4*x2 <= 120, name="cardboard")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible")
