
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("milk_tea_optimization")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="black_milk_tea") # bottles of black milk tea
x2 = m.addVar(vtype=GRB.INTEGER, name="green_milk_tea") # bottles of green milk tea


# Set objective function
m.setObjective(2.5 * x1 + 7 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300 * x1 + 200 * x2 <= 50000, "milk_constraint")
m.addConstr(x1 >= 3 * x2, "black_green_ratio")
m.addConstr(x2 >= 10, "min_green")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of black milk tea bottles: {x1.x}")
    print(f"Number of green milk tea bottles: {x2.x}")

