
from gurobipy import *

# Create a model
m = Model("Milk_Tea_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="black_milk_tea")
x2 = m.addVar(vtype=GRB.INTEGER, name="green_milk_tea")

# Set objective function
m.setObjective(2.5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*x1 + 200*x2 <= 50000, "milk_limit")
m.addConstr(x1 >= 3*x2, "black_green_ratio")
m.addConstr(x2 >= 10, "green_minimum")
m.addConstr(x1 >= 0, "non_negative_black")
m.addConstr(x2 >= 0, "non_negative_green")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bottles of black milk tea: {x1.x}")
    print(f"Number of bottles of green milk tea: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
