
import gurobi as gp

# Create a new model
model = gp.Model("MilkTeaShop")

# Define the variables
x1 = model.addVar(name="black_milk_tea", obj=2.5, lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="green_milk_tea", obj=7, lb=0, vtype=gp.GRB.INTEGER)

# Add constraints
model.addConstr(300 * x1 + 200 * x2 <= 50000, name="milk_constraint")
model.addConstr(x1 >= 3 * x2, name="black_vs_green_constraint")
model.addConstr(x2 >= 10, name="min_green_constraint")

# Set the model to maximize the objective function
model.setObjective(x1.obj * x1 + x2.obj * x2, gp.GRB.MAXIMIZE)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of black milk tea bottles: {x1.varValue}")
    print(f"Number of green milk tea bottles: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
