
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("woodshop")

# Create variables
tables = m.addVar(vtype=GRB.CONTINUOUS, name="tables")
chairs = m.addVar(vtype=GRB.CONTINUOUS, name="chairs")

# Set objective
m.setObjective(1000 * tables + 300 * chairs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * tables + 2 * chairs <= 25, "crafting_constraint")
m.addConstr(2 * tables + 1 * chairs <= 15, "polishing_constraint")
m.addConstr(tables >= 0, "tables_nonnegative")
m.addConstr(chairs >= 0, "chairs_nonnegative")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of tables to produce: {tables.x:.2f}")
    print(f"Number of chairs to produce: {chairs.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

