
from gurobipy import *

# Create a new model
m = Model("Woodshop_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="tables", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="chairs", lb=0)

# Set objective function
m.setObjective(1000*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 2*x2 <= 25, "crafting_hours")
m.addConstr(2*x1 + x2 <= 15, "polishing_hours")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tables produced: {x1.x}")
    print(f"Chairs produced: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
