
import gurobi

def woodshop_production_planning():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="tables", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="chairs", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize profit
    model.setObjective(1000*x1 + 300*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 2*x2 <= 25, name="crafting_hours")
    model.addConstr(2*x1 + x2 <= 15, name="polishing_hours")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Tables: {x1.varValue}")
        print(f"Chairs: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

woodshop_production_planning()
