
import gurobipy as gp

# Create a new model
m = gp.Model("cafe_optimization")

# Create variables
university_hours = m.addVar(lb=0, name="university_hours")
downtown_hours = m.addVar(lb=0, name="downtown_hours")

# Set objective function
m.setObjective(400 * university_hours + 700 * downtown_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(30 * university_hours + 40 * downtown_hours >= 900, "cappuccino_constraint")
m.addConstr(40 * university_hours + 70 * downtown_hours >= 700, "latte_constraint")
m.addConstr(60 * university_hours + 110 * downtown_hours >= 1400, "coffee_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"University Cafe Hours: {university_hours.x}")
    print(f"Downtown Cafe Hours: {downtown_hours.x}")
    print(f"Total Cost: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

