
from gurobipy import *

# Create a new model
m = Model("Cafe_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_university_cafe")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_downtown_cafe")

# Set the objective function
m.setObjective(400*x1 + 700*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 40*x2 >= 900, "cappuccino_constraint")
m.addConstr(40*x1 + 70*x2 >= 700, "latte_constraint")
m.addConstr(60*x1 + 110*x2 >= 1400, "regular_coffee_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"University cafe should be run for {x1.x} hours")
    print(f"Downtown cafe should be run for {x2.x} hours")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")

