
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="university_cafe_hours", lb=0)
x2 = model.addVar(name="downtown_cafe_hours", lb=0)

# Objective function: minimize 400x1 + 700x2
model.setObjective(400 * x1 + 700 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(30 * x1 + 40 * x2 >= 900, name="cappuccino_constraint")
model.addConstr(40 * x1 + 70 * x2 >= 700, name="latte_constraint")
model.addConstr(60 * x1 + 110 * x2 >= 1400, name="regular_coffee_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"University cafe hours: {x1.varValue}")
    print(f"Downtown cafe hours: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
