
import gurobipy as gp

# Create a new model
m = gp.Model("curry_profit")

# Create variables
chicken = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken")  # Servings of chicken curry
goat = m.addVar(vtype=gp.GRB.CONTINUOUS, name="goat")  # Servings of goat curry

# Set objective function
m.setObjective(5 * chicken + 7 * goat, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * chicken + 2 * goat <= 20, "tomatoes")
m.addConstr(2 * chicken + 3 * goat <= 30, "curry_paste")
m.addConstr(3 * chicken + 1 * goat <= 25, "water")
m.addConstr(chicken >= 0)
m.addConstr(goat >= 0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Chicken Curry Servings: {chicken.x}")
    print(f"Goat Curry Servings: {goat.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

