
from gurobipy import *

# Create a new model
m = Model("Curry_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_curry", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="goat_curry", lb=0)

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 2*x2 <= 20, "tomatoes")
m.addConstr(2*x1 + 3*x2 <= 30, "curry_paste")
m.addConstr(3*x1 + x2 <= 25, "water")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
