
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="chicken_curry", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="goat_curry", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(x1 + 2 * x2 <= 20, name="tomatoes_constraint")
    model.addConstr(2 * x1 + 3 * x2 <= 30, name="curry_paste_constraint")
    model.addConstr(3 * x1 + x2 <= 25, name="water_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Chicken curry servings: {x1.varValue}")
        print(f"Goat curry servings: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
