
import gurobipy as gp

# Create a new model
model = gp.Model("CakePopOptimization")

# Create variables
soft = model.addVar(vtype=gp.GRB.INTEGER, name="soft")
smooth = model.addVar(vtype=gp.GRB.INTEGER, name="smooth")
crunchy = model.addVar(vtype=gp.GRB.INTEGER, name="crunchy")

# Set objective function
model.setObjective(4 * soft + 6 * smooth + 5 * crunchy, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * soft + 15 * smooth + 12 * crunchy <= 1000, "batter_constraint")
model.addConstr(10 * soft + 15 * smooth + 18 * crunchy <= 800, "milk_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Number of soft cake-pops: {soft.x}")
    print(f"Number of smooth cake-pops: {smooth.x}")
    print(f"Number of crunchy cake-pops: {crunchy.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

