
from gurobipy import *

# Create a new model
m = Model("cake_pops")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="soft_cake_pops")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="smooth_cake_pops")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="crunchy_cake_pops")

# Define the objective function
m.setObjective(4*x1 + 6*x2 + 5*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 + 12*x3 <= 1000, "batter_limit")
m.addConstr(10*x1 + 15*x2 + 18*x3 <= 800, "milk_limit")

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
