
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="soft_cake_pops", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="smooth_cake_pops", lb=0, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="crunchy_cake_pops", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(4 * x1 + 6 * x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 15 * x2 + 12 * x3 <= 1000, name="batter_constraint")
    model.addConstr(10 * x1 + 15 * x2 + 18 * x3 <= 800, name="milk_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of soft cake-pops: {x1.varValue}")
        print(f"Number of smooth cake-pops: {x2.varValue}")
        print(f"Number of crunchy cake-pops: {x3.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
