
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("woodshop")

# Create variables
dining_tables = m.addVar(vtype=GRB.INTEGER, name="dining_tables")
bed_frames = m.addVar(vtype=GRB.INTEGER, name="bed_frames")

# Set objective function
m.setObjective(300 * dining_tables + 400 * bed_frames, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * dining_tables + 5 * bed_frames <= 300, "oak_constraint")
m.addConstr(5 * dining_tables + 2 * bed_frames <= 400, "mahogany_constraint")
m.addConstr(dining_tables >= 0, "dining_tables_nonnegative")
m.addConstr(bed_frames >= 0, "bed_frames_nonnegative")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Dining Tables: {dining_tables.x}")
    print(f"Bed Frames: {bed_frames.x}")
    print(f"Profit: ${m.objVal}")

