
from gurobipy import *

# Create a new model
m = Model("Woodshop_Optimization")

# Define variables
x1 = m.addVar(name="dining_tables", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="bed_frames", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(300*x1 + 400*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 300, name="oak_wood_constraint")
m.addConstr(5*x1 + 2*x2 <= 400, name="mahogany_wood_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dining Tables: {x1.x}")
    print(f"Bed Frames: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
