
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="dining_tables", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="bed_frames", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(300*x1 + 400*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 5*x2 <= 300, name="oak_wood_constraint")
    model.addConstr(5*x1 + 2*x2 <= 400, name="mahogany_wood_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of dining tables: {x1.varValue}")
        print(f"Number of bed frames: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
