
import gurobipy as gp

# Create a new model
m = gp.Model("investment_problem")

# Create variables
shoe_investment = m.addVar(name="shoe_investment")
hat_investment = m.addVar(name="hat_investment")

# Set objective function
m.setObjective(0.07 * shoe_investment + 0.06 * hat_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(shoe_investment + hat_investment <= 20000, "total_investment")
m.addConstr(shoe_investment >= 4 * hat_investment, "shoe_hat_ratio")
m.addConstr(shoe_investment <= 15000, "max_shoe_investment")
m.addConstr(shoe_investment >=0, 'non_negative_shoe')
m.addConstr(hat_investment >=0, 'non_negative_hat')


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal investment in shoe factory:", shoe_investment.x)
    print("Optimal investment in hat factory:", hat_investment.x)
    print("Maximum earnings:", m.objVal)

