
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="shoe_factory")
x2 = m.addVar(lb=0, name="hat_factory")

# Set the objective function
m.setObjective(0.07*x1 + 0.06*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 20000, "total_investment")
m.addConstr(x1 >= 4*x2, "shoe_hat_ratio")
m.addConstr(x1 <= 15000, "max_shoe_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in shoe factory: {x1.x}")
    print(f"Amount invested in hat factory: {x2.x}")
    print(f"Maximum earnings: {m.objVal}")
else:
    print("No optimal solution found")
