
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # Investment in shoe factory
    x2 = model.addVar(name="x2", lb=0)  # Investment in hat factory

    # Objective function: maximize 0.07*x1 + 0.06*x2
    model.setObjective(0.07 * x1 + 0.06 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 20000, name="total_investment")
    model.addConstr(x1 >= 4 * x2, name="shoe_to_hat_ratio")
    model.addConstr(x1 <= 15000, name="shoe_factory_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in shoe factory: ${x1.varValue:.2f}")
        print(f"Optimal investment in hat factory: ${x2.varValue:.2f}")
        print(f"Maximum earnings: ${0.07*x1.varValue + 0.06*x2.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
