
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_profit")

# Create variables
t_shirts = m.addVar(vtype=GRB.CONTINUOUS, name="t_shirts")
hoodies = m.addVar(vtype=GRB.CONTINUOUS, name="hoodies")

# Set objective function
m.setObjective(10 * t_shirts + 15 * hoodies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * t_shirts + 2 * hoodies <= 40, "design_constraint")
m.addConstr(2 * t_shirts + 3 * hoodies <= 60, "printing_constraint")
m.addConstr(t_shirts >= 0, "t_shirts_nonnegative")
m.addConstr(hoodies >= 0, "hoodies_nonnegative")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of t-shirts: {t_shirts.x}")
    print(f"Number of hoodies: {hoodies.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

