
from gurobipy import *

# Create a new model
m = Model("Clothing_Company_Optimization")

# Define variables
x1 = m.addVar(name="t-shirts", lb=0)
x2 = m.addVar(name="hoodies", lb=0)

# Set the objective function to maximize profit
m.setObjective(10*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 2*x2 <= 40, name="designing_time")
m.addConstr(2*x1 + 3*x2 <= 60, name="printing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of t-shirts: {x1.x}")
    print(f"Number of hoodies: {x2.x}")
    print(f"Maximum profit: ${10*x1.x + 15*x2.x}")
else:
    print("No optimal solution found")
