
import gurobipy as gp

# Create a new model
model = gp.Model("TShirts_Hoodies")

# Define variables
x1 = model.addVar(name="t-shirts", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="hoodies", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function
model.setObjective(10*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + 2*x2 <= 40, name="designing_time")
model.addConstr(2*x1 + 3*x2 <= 60, name="printing_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
  print("Optimal Solution:")
  print(f"t-shirts: {x1.varValue}")
  print(f"hoodies: {x2.varValue}")
  print(f"Max Profit: {model.objVal}")
else:
  print("The model is infeasible.")
