
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("hot_dog_optimization")

    # Create variables
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # Regular hot-dogs
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # Premium hot-dogs


    # Set objective function
    m.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x1 <= 100, "regular_hot_dog_demand")
    m.addConstr(x2 <= 250, "premium_hot_dog_demand")
    m.addConstr(x1 + x2 <= 300, "total_hot_dog_production")
    m.addConstr(x1 >= 0, "regular_hot_dog_nonnegativity")
    m.addConstr(x2 >= 0, "premium_hot_dog__nonnegativity")

    # Optimize model
    m.optimize()

    # Print results
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))

    print('Obj: %g' % m.objVal)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

