
from gurobipy import *

# Create a new model
m = Model("HotDogProduction")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="regular_hotdogs", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="premium_hotdogs", lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "regular_demand")
m.addConstr(x2 <= 250, "premium_demand")
m.addConstr(x1 + x2 <= 300, "total_capacity")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular hot-dogs: {x1.x}")
    print(f"Premium hot-dogs: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
