
import gurobipy as gp

# Create a new model
model = gp.Model("HotDogStore")

# Define the variables
x1 = model.addVar(lb=0, name="regular_hot_dogs")
x2 = model.addVar(lb=0, name="premium_hot_dogs")

# Define the objective function
model.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(x1 <= 100, name="regular_demand_limit")
model.addConstr(x2 <= 250, name="premium_demand_limit")
model.addConstr(x1 + x2 <= 300, name="total_production_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Regular hot-dogs: {x1.varValue}")
    print(f"Premium hot-dogs: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
