
import gurobipy as gp

# Create a new model
m = gp.Model("Pancake Mix Optimization")

# Create variables
x1 = m.addVar(lb=0, name="Mix A (kg)")  # kg of Mix A
x2 = m.addVar(lb=0, name="Mix B (kg)")  # kg of Mix B

# Set objective function: Minimize cost
m.setObjective(20*x1 + 25*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x1 + 0.15*x2 >= 10, "Sugar Constraint")  # Sugar requirement
m.addConstr(0.60*x1 + 0.50*x2 >= 50, "Flour Constraint") # Flour requirement

# Optimize the model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Mix A (kg): {x1.x}")
    print(f"Mix B (kg): {x2.x}")
    print(f"Total Cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

