
from gurobipy import *

# Create a new model
m = Model("Pancake_Mix")

# Create variables
x1 = m.addVar(lb=0, name="Mix_A")
x2 = m.addVar(lb=0, name="Mix_B")

# Set the objective function
m.setObjective(20*x1 + 25*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x1 + 0.15*x2 >= 10, "Sugar_Constraint")
m.addConstr(0.60*x1 + 0.50*x2 >= 50, "Flour_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x1.x} kg of Mix A")
    print(f"Buy {x2.x} kg of Mix B")
    print(f"Total cost: ${20*x1.x + 25*x2.x}")
else:
    print("No optimal solution found")
