
import gurobipy as gp

def solve_pancake_mix_problem():
    # Create a new model
    model = gp.Model("PancakeMix")

    # Define variables
    x1 = model.addVar(name="Mix_A", lb=0)  # Amount of Mix A
    x2 = model.addVar(name="Mix_B", lb=0)  # Amount of Mix B

    # Objective function: Minimize cost
    model.setObjective(20*x1 + 25*x2, gp.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.10*x1 + 0.15*x2 >= 10, name="Sugar_Requirement")
    model.addConstr(0.60*x1 + 0.50*x2 >= 50, name="Flour_Requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal amount of Mix A: {x1.varValue} kg")
        print(f"Optimal amount of Mix B: {x2.varValue} kg")
        print(f"Optimal cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_pancake_mix_problem()
