
import gurobipy as gp

# Create a new model
model = gp.Model("Vacuum_Repair")

# Create variables
home_vacuums = model.addVar(vtype=gp.GRB.CONTINUOUS, name="home_vacuums")  # x1
shop_vacuums = model.addVar(vtype=gp.GRB.CONTINUOUS, name="shop_vacuums")  # x2


# Set objective function
model.setObjective(20 * home_vacuums + 35 * shop_vacuums, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.5 * home_vacuums + 1 * shop_vacuums <= 300, "Disassembly")
model.addConstr(1 * home_vacuums + 2 * shop_vacuums <= 400, "Repair")
model.addConstr(home_vacuums >= 0)
model.addConstr(shop_vacuums >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Home Vacuums to Repair: {home_vacuums.x}")
    print(f"Number of Shop Vacuums to Repair: {shop_vacuums.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

