
from gurobipy import *

# Create a new model
m = Model("Vacuum_Repair")

# Define variables
x1 = m.addVar(name="home_vacuums", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="shop_vacuums", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(20*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x1 + x2 <= 300, name="disassembly_time")
m.addConstr(x1 + 2*x2 <= 400, name="repair_time")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
