
import gurobipy as gp

# Create a new model
model = gp.Model("Vacuum_Repair")

# Define the variables
x1 = model.addVar(name="home_vacuums", obj=20, lb=0)  # home vacuums
x2 = model.addVar(name="shop_vacuums", obj=35, lb=0)  # shop vacuums

# Define the constraints
model.addConstr(0.5 * x1 + 1 * x2 <= 300, name="disassembly_time")  # disassembly time constraint
model.addConstr(1 * x1 + 2 * x2 <= 400, name="repair_time")  # repair time constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GUROBI_OPTIMAL:
    print("Optimal solution found.")
    print(f"Home vacuums: {x1.varValue}")
    print(f"Shop vacuums: {x2.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
