
from gurobipy import Model, GRB

# Create a new model
m = Model("bus_seating")

# Create variables
premium_seats = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
regular_seats = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(40 * premium_seats + 20 * regular_seats, GRB.MAXIMIZE)

# Add constraints
m.addConstr(premium_seats + regular_seats <= 100, "total_seats")
m.addConstr(premium_seats >= 10, "min_premium")
m.addConstr(regular_seats >= 5 * premium_seats, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Premium seats: {premium_seats.x}")
    print(f"Regular seats: {regular_seats.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

