
from gurobipy import *

# Create a new model
m = Model("Tour_Bus_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set the objective function
m.setObjective(40*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_seats")
m.addConstr(x1 >= 10, "min_premium_seats")
m.addConstr(x2 >= 5*x1, "regular_vs_premium")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Premium seats = {x1.x}, Regular seats = {x2.x}")
    print(f"Maximum Profit: ${40*x1.x + 20*x2.x}")
else:
    print("No optimal solution found")
