
import gurobi

def solve_tour_bus_seating():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='premium_seats', lb=0, ub=100, vtype=gurobi.GRB.INTEGER)  # Number of premium seats
    x2 = model.addVar(name='regular_seats', lb=0, ub=100, vtype=gurobi.GRB.INTEGER)  # Number of regular seats

    # Objective function: Maximize 40*x1 + 20*x2
    model.setObjective(40*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name='total_seats')  # Total seats do not exceed 100
    model.addConstr(x1 >= 10, name='min_premium_seats')  # At least 10 premium seats
    model.addConstr(x2 >= 5*x1, name='regular_vs_premium')  # At least 5 times as many regular seats as premium seats

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {model.x[0]} premium seats, {model.x[1]} regular seats")
        print(f"Maximum profit: ${40*model.x[0] + 20*model.x[1]}")
    else:
        print("No optimal solution found")

solve_tour_bus_seating()
