
import gurobipy as gp

# Create a new model
model = gp.Model("CerealMix")

# Create variables
x1 = model.addVar(lb=0, name="servings_cereal_A")  # Servings of cereal A
x2 = model.addVar(lb=0, name="servings_cereal_B")  # Servings of cereal B


# Set objective function
model.setObjective(0.45 * x1 + 0.55 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(25 * x1 + 20 * x2 >= 400, "iron_req")
model.addConstr(30 * x1 + 40 * x2 >= 450, "fiber_req")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal servings of cereal A: {x1.x}")
    print(f"Optimal servings of cereal B: {x2.x}")
    print(f"Minimum cost: ${model.objVal:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

