
from gurobipy import *

# Create a new model
m = Model("Cereal_Mixing")

# Add variables to the model
x1 = m.addVar(lb=0, name="servings_of_cereal_A")
x2 = m.addVar(lb=0, name="servings_of_cereal_B")

# Set the objective function
m.setObjective(0.45*x1 + 0.55*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(25*x1 + 20*x2 >= 400, "Iron_Constraint")
m.addConstr(30*x1 + 40*x2 >= 450, "Fiber_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of Cereal A: {x1.x}")
    print(f"Servings of Cereal B: {x2.x}")
    print(f"Total Cost: ${0.45*x1.x + 0.55*x2.x:.2f}")
else:
    print("No optimal solution found")
