
import gurobi

def solve_cereal_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cereal_A", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="cereal_B", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(0.45 * x1 + 0.55 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(25 * x1 + 20 * x2 >= 400, name="iron_constraint")
    model.addConstr(30 * x1 + 40 * x2 >= 450, name="fiber_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cereal A servings: {x1.varValue}")
        print(f"Cereal B servings: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cereal_problem()
