
import gurobipy as gp

# Create a new model
m = gp.Model("Tropical_Farmer")

# Create variables
guavas = m.addVar(name="guavas")
mangos = m.addVar(name="mangos")

# Set objective function
m.setObjective(300 * guavas + 500 * mangos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(guavas + mangos <= 100, "Total_Land")
m.addConstr(mangos <= 2 * guavas, "Mango_Guava_Ratio")
m.addConstr(guavas >= 20, "Min_Guavas")
m.addConstr(mangos >= 40, "Min_Mangos")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Guavas: {guavas.x} acres")
    print(f"  Mangos: {mangos.x} acres")
    print(f"  Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

