
import gurobipy as gp

# Create a new model
m = gp.Model("TropicalFarmer")

# Define variables
x1 = m.addVar(name="guavas", lb=0)
x2 = m.addVar(name="mangos", lb=0)

# Objective function
m.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 100, name="land_constraint")
m.addConstr(x2 <= 2*x1, name="mango_to_guava_ratio")
m.addConstr(x1 >= 20, name="guava_minimum")
m.addConstr(x2 >= 40, name="mango_minimum")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Acres of guavas: {x1.varValue}")
    print(f"Acres of mangos: {x2.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
