
import gurobipy as gp

# Create a new model
m = gp.Model("fast_food_optimization")

# Create variables
wraps = m.addVar(vtype=gp.GRB.CONTINUOUS, name="wraps")
bowls = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls")


# Set objective function
m.setObjective(5 * wraps + 7 * bowls, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * wraps + 5 * bowls <= 800, "rice_constraint")
m.addConstr(2 * wraps + 3 * bowls <= 700, "fish_constraint")
m.addConstr(wraps >= 0, "wraps_nonnegativity")
m.addConstr(bowls >= 0, "bowls_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Wraps: {wraps.x}")
    print(f"Number of Bowls: {bowls.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

