
from gurobipy import *

# Create a new model
m = Model("FastFoodOptimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="wraps")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls")

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 800, "rice_constraint")
m.addConstr(2*x1 + 3*x2 <= 700, "fish_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of wraps: {x1.x}")
    print(f"Number of bowls: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
